<?php

/**
 * Class that operate on table 'clientarea'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-11-24 10:38
 */
class ClientareaMySqlDAO implements ClientareaDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return ClientareaMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM clientarea WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM clientarea';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM clientarea ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param clientarea primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM clientarea WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param ClientareaMySql clientarea
     */
    public function insert($clientarea) {
        $sql = 'INSERT INTO clientarea (name, comment, webApiId, associatedtag_id) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($clientarea->name);
        $sqlQuery->setString2($clientarea->comment);
        $sqlQuery->setNumber((int) $clientarea->webApiId);
        $sqlQuery->setNumber((int) $clientarea->associatedtag_id);
        $id = $this->executeInsert($sqlQuery);
        $clientarea->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param ClientareaMySql clientarea
     */
    public function update($clientarea) {
        $sql = 'UPDATE clientarea SET name = ?, comment = ?, webApiId = ?, associatedtag_id = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($clientarea->name);
        $sqlQuery->setString2($clientarea->comment);
        $sqlQuery->setNumber((int) $clientarea->webApiId);
        $sqlQuery->setNumber((int) $clientarea->associatedtag_id);
        $sqlQuery->setNumber($clientarea->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM clientarea';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByName($value) {
        $sql = 'SELECT * FROM clientarea WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByComment($value) {
        $sql = 'SELECT * FROM clientarea WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByName($value) {
        $sql = 'DELETE FROM clientarea WHERE name = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByComment($value) {
        $sql = 'DELETE FROM clientarea WHERE comment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return ClientareaMySql
     */
    protected function readRow($row) {
        $clientarea = new Clientarea();

        $clientarea->id = isset($row['id']) ? $row['id'] : '';
        $clientarea->name = isset($row['name']) ? $row['name'] : '';
        $clientarea->comment = isset($row['comment']) ? $row['comment'] : '';
        $clientarea->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';
        $clientarea->governmentid = isset($row['governmentid']) ? $row['governmentid'] : '';
        $clientarea->governmentname = isset($row['governmentname']) ? $row['governmentname'] : '';
        $clientarea->associatedtag_id = isset($row['associatedtag_id']) ? $row['associatedtag_id'] : '';


        return $clientarea;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return ClientareaMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>